/*
// make packed dead and well done pic
*/


#include <stdio.h>
#include <stdlib.h>
#include "../hland.h"

byte buffer[500000UL];

void doit(FILE* outf, char *file_naam, char* naam, long len)
{
  printf("Doing: %s\n", naam);
  {
    long size;
    FILE*f;
    f=fopen(file_naam, "rb");
    if(f==NULL)
    {
      printf("File open error on %s\n",file_naam);
      exit(-1);
    }
    size=fread(buffer, 1, len, f);
    if(size<len)
    {
      len=size;
    }
    fclose(f);
  }
  fprintf(outf, "extern signed char %s[%liUL] = {\n", naam, len);
  {
    long i;
    int w=0;
    for(i=0; i<len; i++)
    {
      fprintf(outf, "%i,", buffer[i]);
      w++;
      if(w>=16)
      {
        fprintf(outf,"\n");
        w=0;
      }
    }
  }
  fprintf(outf, "};\n");
}


int main(void)
{
  FILE*f;
  if((f=fopen("end_data.c","w"))==NULL)
  {
    printf("map data file open error!\n");
    return -1;
  }
  fprintf(f,"/*\n"
            "// file generated by: " __FILE__ "\n"
            "*/\n\n"
         );
  doit(f, "dead.pac", "dead_pac", 32256UL);
  doit(f, "endpic.pac", "endpic_pac", 32256UL);
  fclose(f);
  return 0;
}
